<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Detail_V1 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_project_detail_v1';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Detail V1', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'project_detail_v1',
				[
					'label' => esc_html__( 'Project Detail V1', 'nitech' ),
				]
		);
		$this->add_control(
			'img',
			[
			  'label' => __( 'Feature Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'client',
			[
				'label'       => __( 'Client', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Client Here', 'nitech' ),
			]
		);
		$this->add_control(
			'category',
			[
				'label'       => __( 'Category', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Date Here', 'nitech' ),
			]
		);
		$this->add_control(
			 'show_rating',
			[
				'label'       => __( 'Enable/Disable Rating', 'nitech' ),
                'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'nitech' ),
				'label_off' => __( 'Hide', 'nitech' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'client_rating',
			[
				'label'   => esc_html__( 'Rating', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'1'     => esc_html__( '1 Star', 'nitech' ),
					'2'     => esc_html__( '2 Star', 'nitech' ),
					'3' 	=> esc_html__( '3 Star', 'nitech' ),
					'4'     => esc_html__( '4 Star', 'nitech' ),
					'5'     => esc_html__( '5 Star', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'date',
			[
				'label'       => __( 'Date', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Date Here', 'nitech' ),
			]
		);
		$this->add_control(
			'price',
			[
				'label'       => __( 'Price', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Price Here', 'nitech' ),
			]
		);
		$this->add_control(
			 'show_social',
			[
				'label'       => __( 'Enable/Disable Social Icons', 'nitech' ),
                'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'nitech' ),
				'label_off' => __( 'Hide', 'nitech' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
        	'social_icons', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['social_link' => esc_html__('https://www.facebook.com/', 'nitech')],
				],
			'fields' => 
				[
					[
						'name' => 'social_icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'social_link',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
			'title_field' => '{{social_link}}',
			]	
        );
		$this->add_control(
			'img1',
			[
			  'label' => __( 'Feature Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'des',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
            'feature_list', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title' => esc_html__('Challenges We Faced During The Project Time', 'nitech')],
					['block_title' => esc_html__('Provide Impressive Solution More than Expectation', 'nitech')]
				],
			'fields' => 
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'features_list',
						'label' => esc_html__('Feature List', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		$img = $settings[ 'img' ][ 'url' ];
		$img1 = $settings[ 'img1' ][ 'url' ];
		$title = $settings[ 'title' ];
		$client = $settings[ 'client' ];
		$category = $settings[ 'category' ];
		$date = $settings[ 'date' ];
		$show_rating = $settings[ 'show_rating' ];
		$price = $settings[ 'price' ];
		$show_social = $settings[ 'show_social' ];
		$text = $settings[ 'text' ];
		$des = $settings[ 'des' ];
	?>

	<!-- Project Details Two -->
    <section class="project-details-two">
        <div class="auto-container">
            <div class="two-column">
                <div class="row clearfix">
                    <?php if( $img ):?>
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <figure class="image-box"><img src="<?php echo esc_url( wp_get_attachment_url( $img ) );?>" alt="<?php esc_attr_e( 'Feature Image', 'nitech' );?>"></figure>
                    </div>
                    <?php endif;?>
                    <div class="col-lg-6 col-md-12 col-sm-12 inner-column">
                        <div class="content-box">
                            <?php if( $title ):?>
                            <h4><?php echo wp_kses( $title, true );?></h4>
                            <?php endif;?>
                            <div class="inner-box clearfix">
                                <div class="left-column">
                                    <?php if( $client ):?>
                                    <div class="single-box">
                                        <h6><?php esc_html_e( 'Client:', 'nitech' );?></h6>
                                        <p><?php echo wp_kses( $client, true );?></p>
                                    </div>
                                    <?php endif;?>
                                    <?php if( $category ):?>
                                    <div class="single-box">
                                        <h6><?php esc_html_e( 'Category:', 'nitech' );?></h6>
                                        <p><?php echo wp_kses( $category, true );?></p>
                                    </div>
                                    <?php endif;?>
                                    
                                    <?php if( $show_rating ):?>
                                    <div class="single-box">
                                        <h6><?php esc_html_e( 'Rating:', 'nitech' );?></h6>
                                        <ul class="rating">
                                           
                                           <?php
												$ratting = $settings( 'client_rating' ); 
												for ($x = 1; $x <= 5; $x++) {
												if($x <= $ratting) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>'; 
												}
											?>
                                            
                                        </ul>
                                    </div>
                                    <?php endif;?>
                                </div>
                                <div class="right-column">
                                    <?php if( $date ):?>
                                    <div class="single-box">
                                        <h6><?php esc_html_e( 'Date:', 'nitech' );?></h6>
                                        <p><?php echo wp_kses( $date, true );?></p>
                                    </div>
                                    <?php endif;?>
                                    
                                    <?php if( $price ):?>
                                    <div class="single-box">
                                        <h6><?php esc_html_e( 'Project Value:', 'nitech' );?></h6>
                                        <p><?php echo wp_kses( $price, true );?></p>
                                    </div>
                                    <?php endif;?>
                                    
                                    <?php if( $show_social ):?>
                                    <div class="single-box">
                                        <ul class="social-box clearfix">
                                            <?php foreach($settings['social_icons'] as $key => $item): ?>
                                            <li><a href="<?php echo esc_url($item['social_link']['url']); ?>"><i class="fab <?php echo wp_kses(str_replace( "icon ",  "", $item['social_icons']), true); ?>"></i></a></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                        <?php if( $img1 ):?>
                        <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                            <figure class="image-box"><img src="<?php echo esc_url( wp_get_attachment_url( $img1 ) );?>" alt="<?php esc_attr_e( 'Feature Image', 'nitech' );?>"></figure>
                        </div>
                        <?php endif;?>
                    </div>
                </div>
            </div>
            <?php if( $text || $des ):?>
            <div class="text">
                <p><?php echo wp_kses( $text, true );?></p>
                <p><?php echo wp_kses( $des, true );?></p>
            </div>
            <?php endif;?>
            
            <?php foreach($settings['feature_list'] as $key => $item): ?>
            <div class="single-discription clearfix">
                <div class="title-inner">
                    <h3><i class="<?php echo esc_attr( $item[ 'icons' ] );?>"></i><?php echo wp_kses( $item[ 'block_title' ], true );?></h3>
                </div>
                <div class="text-inner">
                    <p><?php echo wp_kses( $item[ 'block_text' ], true );?></p>
                    
					<?php $features_list = $item['features_list'];
						if(!empty($features_list)){
						$features_list = explode("\n", ($features_list)); 
					?>
					<ul class="list clearfix">
						<?php foreach($features_list as $features): ?>
						<li><?php echo wp_kses($features, true); ?></li>
						<?php endforeach; ?>
					</ul>
					<?php } ?>
                    
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
    <!-- End Project Details Two -->
		
    <?php 
	
	}

}